# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.11",
        python_install_dir=r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib/python3.11/site-packages/",
        python_path=r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/bin/python",

        # Package versions
        contourpy_version="1.3.3",
        meson_version="1.10.1",
        mesonpy_version="0.19.0",
        pybind11_version="3.0.1",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"/Users/runner/miniforge3/conda-bld/bld/rattler-build_contourpy_1769156091/work/builddir/lib/contourpy/util",
        source_dir=r"/Users/runner/miniforge3/conda-bld/bld/rattler-build_contourpy_1769156091/work/lib/contourpy/util",
        cross_build="True",

        # Build options
        build_options=r"-Dbuildtype=release -Db_ndebug=if-release -Db_vscrt=md -Dlibdir=lib -Dprefix=/Users/gitlab-runner/miniforge3/envs/ilastik-release -Dvsenv=True --cross-file=/Users/runner/miniforge3/conda-bld/bld/rattler-build_contourpy_1769156091/build_env/meson_cross_file.txt --native-file=/Users/runner/miniforge3/conda-bld/bld/rattler-build_contourpy_1769156091/work/builddir/meson-python-native-file.ini",
        buildtype="release",
        cpp_std="c++17",
        debug="False",
        optimization="3",
        vsenv="True",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="clang",
        compiler_version="19.1.7",
        linker_id="ld64",
        compile_command="arm64-apple-darwin20.0.0-clang++",

        # Host machine
        host_cpu="arm64",
        host_cpu_family="aarch64",
        host_cpu_endian="little",
        host_cpu_system="darwin",

        # Build machine, same as host machine if not a cross_build
        build_cpu="x86_64",
        build_cpu_family="x86_64",
        build_cpu_endian="little",
        build_cpu_system="darwin",
    )
