SET(Gurobi_ROOT_DIR "$ENV{GUROBI_ROOT_DIR}" CACHE PATH "Gurobi root directory")
IF (WIN32)
execute_process(COMMAND where gurobi.bat
	OUTPUT_VARIABLE GUROBI_BIN_PATH OUTPUT_STRIP_TRAILING_WHITESPACE)
FILE(TO_CMAKE_PATH ${GUROBI_BIN_PATH} GUROBI_BIN_PATH)
SET(Gurobi_HINT_DIR "${GUROBI_BIN_PATH}/../../" CACHE PATH "Gurobi root directory2")
ENDIF(WIN32)

FIND_PATH(Gurobi_INCLUDE_DIR
  gurobi_c.h
  HINTS ${Gurobi_ROOT_DIR}/include
  HINTS ${Gurobi_HINT_DIR}/include
  )

IF(Gurobi_INCLUDE_DIR)
TRY_RUN(
  RUN_RESULT_VAR COMPILE_RESULT_VAR
  ${CMAKE_BINARY_DIR} 
  ${CMAKE_CURRENT_SOURCE_DIR}/findversion.c
  CMAKE_FLAGS
  -DINCLUDE_DIRECTORIES:STRING=${Gurobi_INCLUDE_DIR}
  RUN_OUTPUT_VARIABLE Gurobi_VERSION
  )

IF(RUN_RESULT_VAR)
  MESSAGE("-- Found Gurobi Version = ${Gurobi_VERSION}")
ENDIF(RUN_RESULT_VAR)

FIND_LIBRARY(Gurobi_LIBRARY
  NAMES gurobi${Gurobi_VERSION}
  HINTS ${Gurobi_ROOT_DIR}/lib
  HINTS ${Gurobi_HINT_DIR}/lib
  PATHS ENV LIBRARY_PATH
        ENV LD_LIBRARY_PATH
)

ENDIF(Gurobi_INCLUDE_DIR)
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Gurobi DEFAULT_MSG Gurobi_LIBRARY Gurobi_INCLUDE_DIR)
IF(NOT GUROBI_FOUND)
  MESSAGE("Set GUROBI_ROOT_DIR to point to the correct directory")
ENDIF(NOT GUROBI_FOUND)

MARK_AS_ADVANCED(Gurobi_INCLUDE_DIR Gurobi_LIBRARY) 
