###############################################################################
#   ilastik: interactive learning and segmentation toolkit
#
#       Copyright (C) 2011-2014, the ilastik developers
#                                <team@ilastik.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# In addition, as a special exception, the copyright holders of
# ilastik give you permission to combine ilastik with applets,
# workflows and plugins which are not covered under the GNU
# General Public License.
#
# See the LICENSE file for details. License information is also available
# on the ilastik web site at:
# 		   http://ilastik.org/license.html
###############################################################################
from builtins import range
from qtpy.QtGui import QColor

from lazyflow.operators import OpMultiArraySlicer2
from volumina.api import createDataSource, AlphaModulatedLayer
from volumina import colortables
from ilastik.utility import bind
from ilastik.applets.layerViewer.layerViewerGui import LayerViewerGui


class PredictionViewerGui(LayerViewerGui):
    def __init__(self, *args, **kwargs):
        super(PredictionViewerGui, self).__init__(*args, **kwargs)
        self.topLevelOperatorView.PmapColors.notifyDirty(bind(self.updateAllLayers))
        self.topLevelOperatorView.LabelNames.notifyDirty(bind(self.updateAllLayers))

    def setupLayers(self):
        layers = []
        opLane = self.topLevelOperatorView

        exportedLayers = self._initPredictionLayers(opLane.PredictionProbabilities)
        layers += exportedLayers

        # If available, also show the raw data layer
        rawSlot = opLane.RawImage
        if rawSlot.ready():
            rawLayer = self.createStandardLayerFromSlot(rawSlot)
            rawLayer.name = "Raw Data"
            rawLayer.visible = True
            rawLayer.opacity = 1.0
            layers.append(rawLayer)

        return layers

    def _initPredictionLayers(self, predictionSlot):
        layers = []

        colors = []
        names = []

        opLane = self.topLevelOperatorView

        if opLane.PmapColors.ready():
            colors = opLane.PmapColors.value
        if opLane.LabelNames.ready():
            names = opLane.LabelNames.value

        # Use a slicer to provide a separate slot for each channel layer
        opSlicer = OpMultiArraySlicer2(parent=opLane.viewed_operator().parent)
        opSlicer.Input.connect(predictionSlot)
        opSlicer.AxisFlag.setValue("c")

        colors = [QColor(*c) for c in colors]
        for channel in range(len(colors), len(opSlicer.Slices)):
            colors.append(PredictionViewerGui.DefaultColors[channel])

        for channel in range(len(names), len(opSlicer.Slices)):
            names.append("Class {}".format(channel + 1))

        for channel, channelSlot in enumerate(opSlicer.Slices):
            if channelSlot.ready() and channel < len(colors) and channel < len(names):
                predictsrc = createDataSource(channelSlot)
                predictLayer = AlphaModulatedLayer(predictsrc, tintColor=colors[channel], normalize=(0.0, 1.0))
                predictLayer.opacity = 0.25
                predictLayer.visible = True
                predictLayer.name = names[channel]
                layers.append(predictLayer)

        return layers

        return colors

    DefaultColors = colortables.default16_new
