###############################################################################
#   lazyflow: data flow based lazy parallel computation framework
#
#       Copyright (C) 2011-2014, the ilastik developers
#                                <team@ilastik.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the Lesser GNU General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# See the files LICENSE.lgpl2 and LICENSE.lgpl3 for full text of the
# GNU Lesser General Public License version 2.1 and 3 respectively.
# This information is also available on the ilastik web site at:
# 		   http://ilastik.org/license/
###############################################################################
import z5py
import json
import numpy as np

# This level can be used to issue user-facing log messages
# log messages at this level get special treatment in ilastik:
# those are shown in the status bar
USER_LOGLEVEL = 23

from . import utility
from . import request
from . import classifiers
from . import roi
from . import rtype
from . import stype
from . import graph
from . import slot
from . import operators


class N5JsonEncoder(json.JSONEncoder):
    """
    json encoder for json dumps in z5py
    """

    def default(self, obj):
        if isinstance(obj, np.integer):
            return int(obj)
        if isinstance(obj, np.floating):
            return float(obj)
        return super().default(obj)


z5py.set_json_encoder(N5JsonEncoder)  # Set a json decoder for z5py
