def to_ome(val, axis):
    if axis.lower() == "t":
        if val in case_sensitive_times:
            return val
        if val.lower() in ome_time_units:
            return ome_time_units[val.lower()]
        return ""
    if val in case_sensitive_lengths:
        return val
    if val.lower() in ome_length_units:
        return ome_length_units[val.lower()]
    return "pixel"


ome_length_units = {
    "yottameter": "Ym",
    "yottameters": "Ym",
    "yottametre": "Ym",
    "yottametres": "Ym",
    "zettameter": "Zm",
    "zettametre": "Zm",
    "zettameters": "Zm",
    "zettametres": "Zm",
    "exameter": "Em",
    "exametre": "Em",
    "exameters": "Em",
    "exametres": "Em",
    "em": "Em",
    "petameters": "Pm",
    "petametres": "Pm",
    "petameter": "Pm",
    "petametre": "Pm",
    "terametre": "Tm",
    "terameter": "Tm",
    "terametres": "Tm",
    "terameters": "Tm",
    "tm": "Tm",
    "gigameter": "Gm",
    "gigametre": "Gm",
    "gigameters": "Gm",
    "gigametres": "Gm",
    "gm": "Gm",
    "megameter": "Mm",
    "megametre": "Mm",
    "megameters": "Mm",
    "megametres": "Mm",
    "kilometer": "km",
    "kilometre": "km",
    "kilometers": "km",
    "kilometres": "km",
    "km": "km",
    "hectometer": "hm",
    "hectometre": "hm",
    "hectometers": "hm",
    "hectometres": "hm",
    "hm": "hm",
    "decameter": "dam",
    "decametre": "dam",
    "decameters": "dam",
    "decametres": "dam",
    "dam": "dam",
    "meter": "m",
    "metre": "m",
    "meters": "m",
    "metres": "m",
    "m": "m",
    "decimetre": "dm",
    "decimeter": "dm",
    "decimetres": "dm",
    "decimeters": "dm",
    "dm": "dm",
    "centimeter": "cm",
    "centimetre": "cm",
    "centimeters": "cm",
    "centimetres": "cm",
    "cm": "cm",
    "millimeter": "mm",
    "millimetre": "mm",
    "millimeters": "mm",
    "millimetres": "mm",
    "mm": "mm",
    "micrometer": "µm",
    "micrometre": "µm",
    "micron": "µm",
    "micrometers": "µm",
    "micrometres": "µm",
    "microns": "µm",
    "um": "µm",
    "µm": "µm",
    "μm": "µm",  # Two separate unicode encodings
    "nanometer": "nm",
    "nanometre": "nm",
    "nanometers": "nm",
    "nanometres": "nm",
    "nm": "nm",
    "picometer": "pm",
    "picometre": "pm",
    "picometers": "pm",
    "picometres": "pm",
    "pm": "pm",
    "femtometer": "fm",
    "femtometre": "fm",
    "femtometers": "fm",
    "femtometres": "fm",
    "fm": "fm",
    "attometer": "am",
    "attometre": "am",
    "attometers": "am",
    "attometres": "am",
    "am": "am",
    "zeptometer": "zm",
    "zeptometre": "zm",
    "zeptometers": "zm",
    "zeptometres": "zm",
    "zm": "zm",
    "yoctometer": "ym",
    "yoctometre": "ym",
    "yoctometers": "ym",
    "yoctometres": "ym",
    "ym": "ym",
    "ångström": "Å",
    "ångströms": "Å",
    "angstrom": "Å",
    "angstroms": "Å",
    "Å": "Å",
    "thou": "thou",
    "thous": "thou",
    "line": "li",
    "lines": "li",
    "li": "li",
    "inch": "in",
    "inches": "in",
    "in": "in",
    "foot": "ft",
    "feet": "ft",
    "ft": "ft",
    "yards": "yd",
    "yard": "yd",
    "yd": "yd",
    "miles": "mi",
    "mile": "mi",
    "mi": "mi",
    "ua": "ua",
    "astronomical unit": "ua",
    "light year": "ly",
    "lightyear": "ly",
    "light years": "ly",
    "lightyears": "ly",
    "ly": "ly",
    "parsec": "pc",
    "parsecs": "pc",
    "pc": "pc",
    "point": "pt",
    "points": "pt",
    "pt": "pt",
}

ome_time_units = {
    "yottasecond": "Ys",
    "yottaseconds": "Ys",
    "zettasecond": "Zs",
    "zettaseconds": "Zs",
    "exasecond": "Es",
    "exaseconds": "Es",
    "es": "Es",
    "petaseconds": "Ps",
    "petasecond": "Ps",
    "terasecond": "Ts",
    "teraseconds": "Ts",
    "ts": "Ts",
    "gigasecond": "Gs",
    "gigaseconds": "Gs",
    "gs": "Gs",
    "megasecond": "Ms",
    "megaseconds": "Ms",
    "kilosecond": "ks",
    "kiloseconds": "ks",
    "ks": "ks",
    "hectosecond": "hs",
    "hectoseconds": "hs",
    "hs": "hs",
    "decasecond": "das",
    "decaseconds": "das",
    "das": "das",
    "second": "s",
    "seconds": "s",
    "sec": "s",
    "secs": "s",
    "s": "s",
    "decisecond": "ds",
    "deciseconds": "ds",
    "ds": "ds",
    "centisecond": "cs",
    "centiseconds": "cs",
    "cs": "cs",
    "millisecond": "ms",
    "milliseconds": "ms",
    "microsecond": "µs",
    "microseconds": "µs",
    "us": "µs",
    "µs": "µs",
    "μs": "µs",  # Two separate unicode encodings
    "nanosecond": "ns",
    "nanoseconds": "ns",
    "ns": "ns",
    "picosecond": "ps",
    "picoseconds": "ps",
    "ps": "ps",
    "femtosecond": "fs",
    "femtoseconds": "fs",
    "fs": "fs",
    "attosecond": "as",
    "attoseconds": "as",
    "as": "as",
    "zeptosecond": "zs",
    "zeptoseconds": "zs",
    "zs": "zs",
    "yoctosecond": "ys",
    "yoctoseconds": "ys",
    "ys": "ys",
    "m": "min",
    "min": "min",
    "minutes": "min",
    "minute": "min",
    "h": "h",
    "hr": "h",
    "hrs": "h",
    "hour": "h",
    "hours": "h",
    "d": "d",
    "day": "d",
    "days": "d",
}

case_sensitive_lengths = ["Mm", "mm", "Pm", "pm", "Ym", "ym", "Zm", "zm"]
case_sensitive_times = ["Ms", "ms", "Ps", "ps", "Ys", "ys", "Zs", "zs"]
