# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy.core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld64",
                "version": "16.0.6",
                "commands": r"arm64-apple-darwin20.0.0-clang",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/numpy_1707225640867/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -L/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/numpy_1707225640867/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.8",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld64",
                "version": "16.0.6",
                "commands": r"arm64-apple-darwin20.0.0-clang++",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/numpy_1707225640867/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -L/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/numpy_1707225640867/work=/usr/local/src/conda/numpy-1.26.4, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "arm64",
                "family": "aarch64",
                "endian": "little",
                "system": "darwin",
            },
            "build": {
                "cpu": "aarch64",
                "family": "aarch64",
                "endian": "little",
                "system": "darwin",
            },
            "cross-compiled": bool("True".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/include",
                "lib directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib/pkgconfig",
            },
            "lapack": {
                "name": "dep4377784592",
                "found": bool("True".lower().replace("false", "")),
                "version": "1.26.4",
                "detection method": "internal",
                "include directory": r"unknown",
                "lib directory": r"unknown",
                "openblas configuration": r"unknown",
                "pc file directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/bin/python",
            "version": "3.11",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
