# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld64",
                "version": "19.1.7",
                "commands": r"arm64-apple-darwin20.0.0-clang",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0, -mmacosx-version-min=11.0",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -L/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0, -mmacosx-version-min=11.0",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld64",
                "version": "19.1.7",
                "commands": r"arm64-apple-darwin20.0.0-clang++",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0, -mmacosx-version-min=11.0",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -L/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -mmacosx-version-min=11.0, -mmacosx-version-min=11.0",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld64",
                "version": "14.3.0",
                "commands": r"/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/_build_env/bin/arm64-apple-darwin20.0.0-gfortran",
                "args": r"-march=armv8.3-a, -ftree-vectorize, -fPIC, -fno-stack-protector, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -L/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib, -march=armv8.3-a, -ftree-vectorize, -fPIC, -fno-stack-protector, -O2, -pipe, -isystem, /Users/gitlab-runner/miniforge3/envs/ilastik-release/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/scipy-split_1768799654612/work=/usr/local/src/conda/scipy-split-1.17.0, -fdebug-prefix-map=/Users/gitlab-runner/miniforge3/envs/ilastik-release=/usr/local/src/conda-prefix",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../_build_env/venv/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"arm64",
                "family": r"aarch64",
                "endian": r"little",
                "system": r"darwin",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"darwin",
            },
            "cross-compiled": bool("True".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/include",
                "lib directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/include",
                "lib directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.1",
                "detection method": "pkgconfig",
                "include directory": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/include",
            },
        },
        "Python Information": {
            "path": r"/Users/gitlab-runner/miniforge3/envs/ilastik-release/bin/python",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
